//+------------------------------------------------------------------+
//|                                             TradeReportModel.mqh |
//|                        Copyright 2025, MetaQuotes Software Corp. |
//|                   https://www.mql5.com/en/users/swedishforexking |
//+------------------------------------------------------------------+
#property copyright "Copyright 2025, MetaQuotes Software Corp."
#property link      "https://www.mql5.com/en/users/swedishforexking"
#property version   "1.00"

//+------------------------------------------------------------------+
//| TradeReportModel.mqh                                             |
//+------------------------------------------------------------------+
#include "DatabaseORM v1.0.mqh"

//+------------------------------------------------------------------+
class CTradeReportModel : public CBaseModel
  {
private:
   long              m_id;
   string            m_strategy_name;
   datetime          m_report_date;
   double            m_total_net_profit;
   double            m_profit_factor;
   double            m_max_drawdown_relative;
   int               m_total_trades;
   string            m_parameters;

public:
                     CTradeReportModel(string table_name="trade_report") : CBaseModel(table_name)
     {
      m_id = 0;
      m_total_net_profit = 0;
      m_profit_factor = 0;
      m_max_drawdown_relative = 0;
      m_total_trades = 0;
     }

                     CTradeReportModel(const CTradeReportModel& model) : CBaseModel(model)
     {
     }



   void              DefineFields() override
     {
      AddField("id", FIELD_TYPE_INT, PRIMARY_KEY | AUTO_INCREMENT | REQUIRED);
      AddField("strategy_name", FIELD_TYPE_STRING, REQUIRED);
      AddField("report_date", FIELD_TYPE_DATETIME, REQUIRED);
      AddField("total_net_profit", FIELD_TYPE_DOUBLE);
      AddField("profit_factor", FIELD_TYPE_DOUBLE);
      AddField("max_drawdown_relative", FIELD_TYPE_DOUBLE);
      AddField("total_trades", FIELD_TYPE_INT);
      AddField("parameters", FIELD_TYPE_STRING);
     }

   string            GetInsertQuery() override
     {
      string query = StringFormat("INSERT INTO %s (strategy_name, report_date, total_net_profit, profit_factor, " +
                                  "max_drawdown_relative, total_trades, parameters) " +
                                  "VALUES ('%s','%s', %d, %.2f, %.2f, %d, '%s')",
                                  GetTableName(),
                                  m_strategy_name, TimeToString(m_report_date), m_total_trades, m_profit_factor, m_max_drawdown_relative,
                                  m_total_trades, m_parameters);

      return query;
     }

   void              LoadFromStatement(int statement, CDatabase &db) override
     {
      m_id = db.ColumnInt(statement, 0);
      m_strategy_name = db.ColumnText(statement, 1);
      m_report_date = (datetime)db.ColumnInt(statement, 2);
      m_total_net_profit = db.ColumnDouble(statement, 3);
      m_profit_factor = db.ColumnDouble(statement, 4);
      m_max_drawdown_relative = db.ColumnDouble(statement, 5);
      m_total_trades = db.ColumnInt(statement, 6);
      m_parameters = db.ColumnText(statement, 7);
     }

   // Setters
   void              SetStrategyName(string name) { m_strategy_name = name; m_fields["strategy_name"].SetValue(name); }
   void              SetTotalNetProfit(double profit) { m_total_net_profit = profit; m_fields["total_net_profit"].SetValue(profit);}
   void              SetProfitFactor(double factor) { m_profit_factor = factor; m_fields["profit_factor"].SetValue(factor);}
   void              SetMaxDrawdown(double max_dd) { m_max_drawdown_relative = max_dd; m_fields["max_drawdown_relative"].SetValue(max_dd);}
   void              SetReportDate(datetime date) { m_report_date = date; m_fields["report_date"].SetValue(date);}
   void              SetTotalTrades(int total) { m_total_trades = total; m_fields["total_trades"].SetValue(total);}
   void              SetParameters(string param) { m_parameters = param; m_fields["parameters"].SetValue(param);}

   // Getters
   long              GetId() const { return m_id; }
   string            GetStrategyName() const { return m_strategy_name; }
   double            GetTotalNetProfit() const { return m_total_net_profit; }
   double            GetProfitFactor() const { return m_profit_factor; }
   double            GetMaxDrawdown() const { return m_max_drawdown_relative; }
   datetime          GetReportDate() const { return m_report_date; }
   int               GetTotalTrades() const { return m_total_trades; }
   string            GetParameters() const { return m_parameters; }

  };




//+------------------------------------------------------------------+
